/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class AbstractBuildingServerMessage<T extends IBuilding>
extends AbstractColonyServerMessage {
    private BlockPos buildingId;

    public AbstractBuildingServerMessage() {
    }

    public AbstractBuildingServerMessage(IBuildingView building) {
        this(building.getColony().getDimension(), building.getColony().getID(), building.getID());
    }

    public AbstractBuildingServerMessage(RegistryKey<World> dimensionId, int colonyId, BlockPos buildingId) {
        super(dimensionId, colonyId);
        this.buildingId = buildingId;
    }

    public boolean errorIfCastFails() {
        return true;
    }

    protected abstract void onExecute(NetworkEvent.Context var1, boolean var2, IColony var3, T var4);

    @Override
    protected final void toBytesAbstractOverride(PacketBuffer buf) {
        buf.func_179255_a(this.buildingId);
    }

    @Override
    protected final void fromBytesAbstractOverride(PacketBuffer buf) {
        this.buildingId = buf.func_179259_c();
    }

    @Override
    public final void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        block3: {
            IBuilding building = colony.getBuildingManager().getBuilding(this.buildingId);
            if (building == null) {
                return;
            }
            try {
                this.onExecute(ctxIn, isLogicalServer, colony, building);
            }
            catch (ClassCastException e) {
                if (!this.errorIfCastFails()) break block3;
                Log.getLogger().warn("onExecute called with wrong type: ", (Throwable)e);
            }
        }
    }
}

